        TITLE "LCD TEST version 1.01"
;either change next two lines if PIC is a 16F84 and recompile,
; or change config. bits on programmer manually 
        list P=16C84, F=INHX8M
        __config 0x3FFA

 noexpand
;****************************************************************************
;*                                                                          *
;*                          LCD TEST CODE                                   *
;*                                                                          *
;*              To test an attached LCD and connections                     *
;*                                                                          *
;* This file and the resulting compiled code copyright1993-97 Steve Lawther *
;*      Use of any of this code requires Steve Lawther to have a credit     *
;*        within the source code. Commercial use of any of this code        *
;*             requires permission of the author, Steve Lawther             *
;*   For more details read 'README.TXT' or email 100255.157@compuserve.com  *
;****************************************************************************
;*                                                                          *
;*  Interfaces to:-                                                         *
;*                                                                          *
;*  a)  An LCD display based on the HD44780 or compatible controller        *
;*      (compatibles believed to be, but not tested:-                       *
;*       Samsung KS0066                                                     *
;*       Sanyo   LC7985 NA                                                  *
;*       Epson   SED1278                                                    *
;*       UMC     UM3881B                                                    *
;*       OKI     MSM6222                                                    *
;*       NJR     NJU62xx various)                                           *
;*                                                                          *
;*  b)  A LED to indicate status or faults                                  *
;*                                                                          *
;*    indication, repeated every 4 seconds :-                               *
;*                                                                          *
;*  constantly on or off - PIC not running, or not programmed correctly     *
;*   1 x 1/2 sec flash   - all ok - if display not readable, alter contrast *
;*   2 x 1/2 sec flashes - Pins shorted / wired wrong                       *
;*   3 x 1/2 sec flashes - LCD busy too long or no display attached         *
;*   4 x 1/2 sec flashes - address readback incorrect - check data wiring   *
;*                                                                          *
;*     When correctly connected, and contrast set correctly, part of        *
;*       character set will be displayed                                    *
;*     For 4x40 character displays, first connect PIC pin 7 (Enable) to     *
;*       EN1 of the LCD to check the top half, then to EN2 for bottom half  *
;*                                                                          *
;*                                                                          *
;****************************************************************************
;* This outline requires IBM line draw chrs                                 *
;*                             \/Ŀ                                 *
;*                   nc       ͵ra2   ra1  spare                         *
;*                   nc       ͵ra3    ra0  led via resistor to +5V       *
;*                   nc       ͵ra4ck osc1  \ Crystal 10MHz               *
;*                  Vdd       ͵mclr  osc2  /                             *
;*                 ground     ͵Vss    Vdd  +5V                           *
;*                   nc       ͵rb0int rb7 LCD data bit 7                 *
;*             LCD cntrl E    ͵rb1    rb6 LCD data bit 6                 *
;*             LCD cntrl R/W  ͵rb2    rb5 LCD data bit 5                 *
;*             LCD cntrl RS   ͵rb3    rb4 LCD data bit 4                 *
;*                                                              *
;*                                                                          *
;****************************************************************************
;History:-
;ver 1.00 - original version
;
;    1.01 - altered incorrect title, and increased wait time on Clear display
;               as the original HD44780 needs upto 15.2ms

Clock_Freq      equ     d'10000000' ;10MHz - for wait macro calculations

HALFSECCOUNT    equ     0x13

 include "lm032l.h"
 include "P16c84.inc"
 include "testlcd.h"
 
 include "wait.mac"

LCD_DATA         EQU     PORTB
LCD_DATA_TRIS    EQU     TRISB
LCD_CTRL         EQU     PORTB

; LCD Display Commands and Control Signal names.

#define LCD_E    LCD_CTRL,1   ; LCD Enable control line
#define LCD_R_W  LCD_CTRL,2   ; LCD Read/Write control line
#define LCD_RS   LCD_CTRL,3   ; LCD Register Select control line

#define LED      PORTA,0   ; LED - clear for lit, set for off
 

;First the powerup code
;reset vector
         org    000h    ; 
         goto   Main         

;Interrupt vector - Only timer used - Status and W not saved as neither
;are altered; this is the reason for the incfsz, not incf
                org     004h
                
                bcf     INTCON, T0IF
                incfsz  TICKCOUNT, F
                retfie
                retfie

;    
;****************************************************************
;       Power up routine
;       This is the program entry point.  All unused I/O lines
;       set for I/P.
;****************************************************************

Main
          bsf   STATUS, RP0
          movlw b'00011110'
          movwf TRISA           ; set all port A as I/P, except A0 - LED O/P
          movlw b'00000001'
          movwf TRISB           ;set all port B to o/p, except B1 - I/P
          movlw b'11010111'     ;setup timer and 1/256 prescaler
          movwf OPTION_REG
          
          bcf   STATUS,RP0
          movlw b'00011111'
          movwf PORTA         ; LED off
          clrf  PORTB
          
          movlw b'10100000'     ;only timer enabled
          movwf INTCON
                   
endlessloop
                clrf    TICKCOUNT
                bcf     LED
halfsec         movlw   HALFSECCOUNT
                subwf   TICKCOUNT, W
                btfss   STATUS, C
                goto    halfsec
                bsf     LED
                
                call    CHECK_LCD
onesec          movlw   ( 2 * HALFSECCOUNT )
                subwf   TICKCOUNT, W
                btfss   STATUS, C
                goto    onesec

                btfss   LCDflags, FAILbit0
                btfsc   LCDflags, FAILbit1
                bcf     LED                
onehalfsec      movlw   ( 3 * HALFSECCOUNT )
                subwf   TICKCOUNT, W
                btfss   STATUS, C
                goto    onehalfsec
                bsf     LED

twosec          movlw   ( 4 * HALFSECCOUNT )
                subwf   TICKCOUNT, W
                btfss   STATUS, C
                goto    twosec

                btfsc   LCDflags, FAILbit1
                bcf     LED
twohalfsec      movlw   ( 5 * HALFSECCOUNT )
                subwf   TICKCOUNT, W
                btfss   STATUS, C
                goto    twohalfsec
                bsf     LED
                
threesec        movlw   ( 6 * HALFSECCOUNT )
                subwf   TICKCOUNT, W
                btfss   STATUS, C
                goto    threesec
               
                bcf     LED
                btfsc   LCDflags, FAILbit0
                btfss   LCDflags, FAILbit1
                bsf     LED
threehalfsec    movlw   ( 7 * HALFSECCOUNT )
                subwf   TICKCOUNT, W
                btfss   STATUS, C
                goto    threehalfsec
                bsf     LED
                
foursec         movlw   ( 9 * HALFSECCOUNT )
                subwf   TICKCOUNT, W
                btfss   STATUS, C
                goto    foursec
                
                goto    endlessloop


; Initilize the LCD Display Module
;****************************************************************************
;*
;*              DISPLAY RESET
;*
;****************************************************************************
CHECK_LCD
;needs to have full routine to initialize corrupted display
;first setup lcd port - all outputs  
                

                BSF     STATUS, RP0     ; Bank 1
                movlw   b'00000001'
                movwf   LCD_DATA_TRIS   ;set all except PB0 to output
                BCF     STATUS, RP0     ; Bank 0
                CLRF    LCD_DATA        ;set all port low
                clrf    LCDflags
                movf    LCD_DATA, F
                andlw   b'11111110'     ;remove bit0
                btfss   STATUS, Z       ;check all of the port has gone low
                goto    FAIL1           ; within 1600ns 

                Wait    15 Millisec, 0

                MOVLW   b'00110000'     ; Command for 8-bit interface high nibble
                MOVWF   LCD_DATA        ; ie 0011xxxx
                BSF     LCD_E      
                nop                     ;incase the clk is >8MHz

                movf    LCD_DATA, W
                andlw   b'11111110'
                sublw   b'00110010'
                btfss   STATUS, Z       ;check all of the port is correct
                goto    FAIL1       
                
                BCF     LCD_E
                     
;have to wait 4.1ms here            
                Wait    4100 Microsec, 0
                BSF     LCD_E           ;nibble is already setup
                nop                     ;incase the clk is >8MHz
                BCF     LCD_E     
;have to wait 100us here
                Wait    100 Microsec, 0
                BSF     LCD_E           ;nibble is already setup
                nop                     ;incase the clk is >8MHz
                BCF     LCD_E     
;have to wait 100us here
                Wait    100 Microsec, 0
                MOVLW   b'00100000'     ; Command for 4-bit interface high nibble
                MOVWF   LCD_DATA        ; ie 0010xxxx
                BSF     LCD_E      
                nop                     ;incase the clk is >8MHz
                BCF     LCD_E

;from here interface is 4 bit and busy can be checked
                                        ;          001DL NF**
                MOVLW   FUNC_SET        ;has to be 0010  10XX 
                CALL    SEND_CMD_W        
                btfsc   LCDflags, LCDBAD
                return
                                        ;0000 1DCB
                MOVLW   DISP_OFF        ;0000 1000  
                CALL    SEND_CMD_W       
                btfsc   LCDflags, LCDBAD
                return
                

                ;****************************
                ;*                          *
                ;*    INITIALIZE DISPLAY    *
                ;*                          *
                ;****************************
INIT_DISPLAY
                                
                MOVLW   CLR_DISP        ; Clear the Display
                CALL    SEND_CMD_W
                btfsc   LCDflags, LCDBAD
                return
                
                MOVLW   DISP_ON_C       ; Display On, Cursor On
                CALL    LONG_WAIT_CMD   ; the clear display above takes a long time             
                btfsc   LCDflags, LCDBAD
                return
                                        ;0000 01IS - incrementing display
                MOVLW   ENTRY_INC       ;0000 0110
                CALL    SEND_CMD_W      
                btfsc   LCDflags, LCDBAD
                return
                
                MOVLW   b'10000000'     ;address zero
                CALL    SEND_CMD_W      ;        
                btfsc   LCDflags, LCDBAD
                return


;display text
                clrf    addrshouldbe
CHARLOOP
                movf    addrshouldbe, W
                addlw   0x20
                call    SEND_CHAR_W
                btfsc   LCDflags, LCDBAD
                return
                
                incf    addrshouldbe, W
                addlw   ( 0 - 0x28)
                btfsc   STATUS, Z
                addlw   0x18
                addlw   0x28
                movwf   addrshouldbe
                sublw   0x68
                btfss   STATUS, Z
                goto    CHARLOOP
                clrf    LCDflags        ;all's good
                
                return

            
                
;*******************************************************************
;* SEND_CMD - Sends command to LCD                                 *
;* This routine splits the command into the upper and lower        * 
;* nibbles and sends them to the LCD, upper nibble first.          *
;*******************************************************************

LONG_WAIT_CMD
                movwf   CHARBUF
                Wait    4000 Microsec, 0
                movf    CHARBUF, W


SEND_CMD_W
                MOVWF   CHARBUF         ; Character to be sent is in W so put in
                                        ;local CHARBUF
                Wait    200 Microsec, 0

; This code checks the busy flag, error if still busy

            BSF     STATUS, RP0     ; Select Register page 1
            MOVLW   0x0F1           ; Set high nibble for I/P
            MOVWF   LCD_DATA_TRIS
            BCF     STATUS, RP0     ; Select Register page 0
            BCF     LCD_RS          ; Set LCD for Command mode
            BSF     LCD_R_W         ; Setup to read busy flag
            BSF     LCD_E           ; Set E high
            nop                     ;incase the clk is >8MHz
            movf    LCD_DATA, W     ; Read upper nibble busy flag, DDRam address            
            andlw   0x0E
            xorlw   b'00000110'
            btfss   STATUS, Z       ; if input reads differently to what it should be
            goto    FAIL1    

            movf    LCD_DATA, W     ; Read upper nibble busy flag, DDRam address            
            BCF     LCD_E           ; Set E low

            nop
            nop
            BSF     LCD_E           ; Toggle E to get lower nibble
            nop
            nop                     ;incase the clk is >8MHz
            BCF     LCD_E      
            andlw   0x80
            btfss   STATUS, Z       
            GOTO    FAIL2           ; If busy, then fault, as it has had enough time
            BCF     LCD_R_W        
            BSF     STATUS, RP0     ; Select Register page 1
            movlw   b'00000001'
            movwf   LCD_DATA_TRIS   ; Set for output
            BCF     STATUS, RP0     ; Select Register page 0
            
;end of busycheck - send the command code
            movf    CHARBUF, W
            ANDLW   0x0F0            ; Get upper nibble into lower half port
            MOVWF   LCD_DATA        ; Send data to LCD
            BSF     LCD_E           ; toggle E for LCD
            nop                     ;incase the clk is >8MHz
            ;nop                     ;incase the clk is >16MHz
            BCF     LCD_E
            swapf   CHARBUF,w
            ANDLW   0x0F0            ; Get lower nibble into lower half port
            MOVWF   LCD_DATA        ; Send data to LCD
            BSF     LCD_E           ; toggle E for LCD
            nop                     ;incase the clk is >8MHz
            ;nop                     ;incase the clk is >16MHz
            BCF     LCD_E
            RETURN

;*******************************************************************
;*SendChar - Sends character to LCD                                *
;*This routine splits the character into the upper and lower       * 
;*nibbles and sends them to the LCD, upper nibble first.           *
;*******************************************************************
;
SEND_CHAR_W
            MOVWF   CHARBUF         ;Character to be sent is in W so put in
                                        ;local CHARBUF
                Wait    100 Microsec, 0

SEND_CHAR

;check that not busy, and address is correct            
            BSF     STATUS, RP0     ; Select Register page 1
            MOVLW   0x0F1           ; Set high nibble + keep INT for input 
            MOVWF   LCD_DATA_TRIS
            BCF     STATUS, RP0     ; Select Register page 0
            BCF     LCD_RS          ; Set LCD for Command mode
            BSF     LCD_R_W         ; Setup to read busy flag
            BSF     LCD_E           ; Set E high
            nop                     ;incase the clk is >8MHz
            movf    LCD_DATA, W     ; Read upper nibble busy flag, DDRam address            
            BCF     LCD_E           ; Set E low
            ANDLW   0x0F0           ; Mask out lower nibble
            MOVWF   TEMP
            nop
            BSF     LCD_E           ; Toggle E to get lower nibble
            nop
            nop                     ;incase the clk is >8MHz
            swapF   LCD_DATA, W     ; Read lower nibble DDRam address
            BCF     LCD_E      
            ANDLW   0x0F            ; Mask out upper nibble
            IORWF   TEMP, F            ; Combine nibbles
            
            BTFSC   TEMP, 7         ; ****Check busy flag, high = busy
            GOTO    FAIL2           ; If busy, error
            BCF     LCD_R_W        
            BSF     STATUS, RP0     ; Select Register page 1
            movlw   b'00000001'
            movwf   LCD_DATA_TRIS   ; Set for output
            BCF     STATUS, RP0     ; Select Register page 0
            movf    addrshouldbe, W
            subwf   TEMP, W
            btfss   STATUS, Z        
            goto    FAIL3           ;probably data wires crossed
            
;end busycheck

            movf    CHARBUF, W
            ANDLW   0x0F0           ;Get upper nibble into upper half port
            MOVWF   LCD_DATA        ;Send data to LCD
            BSF     LCD_RS          ;Set LCD to data mode
            BSF     LCD_E           ;toggle E for LCD
            nop                     ;incase the clk is >8MHz
            
            BCF     LCD_E
            swapf   CHARBUF, W
            ANDLW   0x0F0            ;Get lower nibble into upper half port
            MOVWF   LCD_DATA        ;Send data to LCD
            BSF     LCD_RS          ;Set LCD to data mode
            BSF     LCD_E           ;toggle E for LCD
            nop                     ;incase the clk is >8MHz
            
            BCF     LCD_E
            RETURN



FAIL1           ;pin shorted / wired wrong

                movlw   b'00000101'
                movwf   LCDflags
                return
                
FAIL2           ;pin shorted / wired wrong

                movlw   b'00000110'
                movwf   LCDflags
                return

FAIL3           ;pin shorted / wired wrong

                movlw   b'00000111'
                movwf   LCDflags
                return


#include "delay.asm"

         
        end
