        TITLE "Tosh T6963C based Dot Matrix LCD tester"
        list P=16C84, F=INHX8M

        __config 0x3FFA
 noexpand
;****************************************************************************
;*                                                                          *
;*                      LCD tester                                          *
;*                                                                          *
;* This file and the resulting compiled code copyright 1997 Steve Lawther   *
;*      Use of any of this code requires Steve Lawther to have a credit     *
;*        within the source code. Commercial use of any of this code        *
;*             requires permission of the author, Steve Lawther             *
;*   For more details read 'README.TXT' or email 100255.157@compuserve.com  *
;****************************************************************************
;*                                                                          *
;*  Interfaces to:-                                                         *
;*                                                                          *
;****************************************************************************
;* This outline requires IBM line draw chrs                                 *
;*                             \/Ŀ                                 *
;*             LCD /WR        ͵ra2   ra1 LCD /RD                        *
;*             LCD /CE        ͵ra3    ra0 LCD C\/D                       *
;*                   spare    ͵ra4ck osc1                                *
;*                   Vdd      ͵mclr  osc2                                *
;*                    ground  ͵Vss    Vdd +5V                            *
;*             LCD data bit 0 ͵rb0int rb7 LCD data bit 7                 *
;*             LCD data bit 1 ͵rb1    rb6 LCD data bit 6                 *
;*             LCD data bit 2 ͵rb2    rb5 LCD data bit 5                 *
;*             LCD data bit 3 ͵rb3    rb4 LCD data bit 4                 *
;*                                                              *
;*                                                                          *
;****************************************************************************
;History:-
;ver 

Clock_Freq      equ     d'10000000' ;10MHz

 include "P16c84.inc"
 include "TSTDMLCD.h"
 
 include "wait.mac"

;    
;****************************************************************
;       Power up routine
;       This is the program entry point.  I/O line status is
;       set for port A here.
;****************************************************************

          org   000h
Powerup
          movlw b'00011111'
          movwf PORTA          
          bsf   STATUS, RP0
          clrf  TRISA           ; set all port A as output
          clrf  TRISB           ;set all port B to o/p
          movlw b'10010111'
          movwf OPTION_REG
          
          bcf   STATUS,RP0
          movlw b'00011111'
          movwf PORTA         ; all output lines high
          clrf  PORTB
          movlw 0x03
          movwf PCLATH
          
                
                Wait    60 Millisec, 0

                
                                
;clear screen
startofshapes
                call    INIT_GDISPLAY
                bsf     BITS1_PTR, 3
                call    CLEAR_GRAPHIC
                call    wait_key
                
                bcf     BITS1_PTR, 3
                call    CLEAR_GRAPHIC
                call    wait_key
                
                        call    GRAPH_PTR_HOME
                        
                        clrf    DATABUFA
                        movlw   0x08
                        movwf   tempone
checkloop1              clrf    temptwo
                        comf    DATABUFA, F 
                        
checkloop2              comf    DATABUFA, F 
                        movlw   DATA_WR_INC
                        movwf   COMMANDBUF
                        call    SEND_1DATA_CMD   
                        decfsz  temptwo, F
                        goto    checkloop2
                        decfsz  tempone, F
                        goto    checkloop1

                        call    wait_key                
                
                clrf    Xcoord
                clrf    Ycoord
boxes           movf    Xcoord, W
                movwf   X1_PTRLOW
                sublw   0xEF
                movwf   X2_PTRLOW
                movf    Ycoord, W
                movwf   Y1_PTRHIGH
                sublw   0x3F
                movwf   Y2_PTRHIGH
                movlw   b'00011000'
                movwf   BITS1_PTR
                call    DRAWRECT
                movlw   0x04
                addwf   Xcoord, F
                incf    Ycoord, F
                incf    Ycoord, F
                movf    Ycoord, W
                sublw   0x1E
                btfss   STATUS, Z
                 goto   boxes
                call    wait_key
                                
                clrf    Xcoord
                clrf    Ycoord
                ;bsf     movement, Ymovebit
                ;bsf     movement, Xmovebit
                 
welcome         bcf     BITS1_PTR, 3
                call    CLEAR_GRAPHIC
                
                clrf    X1_PTRLOW
                movlw   0xC7
                movwf   X2_PTRLOW
                clrf    Y1_PTRHIGH
                movlw   0x3F
                movwf   Y2_PTRHIGH
                movlw   b'00011000'
                movwf   BITS1_PTR
                call    DRAWRECT
                
                movlw   0x02
                movwf   X1_PTRLOW
                movwf   Y1_PTRHIGH
                movlw   0xC5
                movwf   X2_PTRLOW
                movlw   0x3D
                movwf   Y2_PTRHIGH
                movlw   b'00001000'
                movwf   BITS1_PTR
                call    DRAWRECT
                
                movlw   0x13
                movwf   Ycoord
                clrf    countno
                
nextlinewel     movlw   0x05
                movwf   Xcoord
                movlw   0x40
                movwf   X1_PTRLOW
                movf    Ycoord, W
                movwf   Y1_PTRHIGH
                call    DRAWDOT         ;just to get postion
nextbytewel
                movf    countno, W                
                call    getwelcomebyte
                movwf   DATABUFB        ;just as temp storage
                call    displayhalf
                swapf   DATABUFB, F
                call    displayhalf
                incf    countno, F
                decfsz  Xcoord, F
                 goto   nextbytewel        
                                
                incf    Ycoord, F
                movf    countno, W
                addlw   0xAA
                btfss   STATUS, C
                 goto   nextlinewel
                
                
                
                movlw   0x2C
                movwf   Ycoord
                
nextlinefs3     movlw   0x03
                movwf   Xcoord
                movlw   0x50
                movwf   X1_PTRLOW
                movf    Ycoord, W
                movwf   Y1_PTRHIGH
                call    DRAWDOT         ;just to get postion
nextbytefs3
                movf    countno, W                
                call    getwelcomebyte
                movwf   DATABUFB        ;just as temp storage
                call    displayhalf
                swapf   DATABUFB, F
                call    displayhalf
                incf    countno, F
                decfsz  Xcoord, F
                 goto   nextbytefs3        
                                
                incf    Ycoord, F
                movf    countno, W
                addlw   0x8D
                btfss   STATUS, C
                 goto   nextlinefs3
                
                call    wait_key

sineish         bcf     BITS1_PTR, 3
                call    CLEAR_GRAPHIC
                clrf    X1_PTRLOW
                clrf    Y1_PTRHIGH
                movlw   0x3F
                movwf   Y2_PTRHIGH
                clrf    BITS1_PTR
                bsf     BITS1_PTR, 3
                call    DRAWVERT
                
                clrf    X1_PTRLOW
                movlw   0x1F
                movwf   Y1_PTRHIGH
                movlw   0xEF
                movwf   X2_PTRLOW
                clrf    BITS1_PTR
                bsf     BITS1_PTR, 3
                call    DRAWHORIZ
                
                clrf    Xcoord
                movlw   0xEF
                movwf   Ycoord
nextsineish     movf    Xcoord, W
                movwf   X1_PTRLOW
                btfsc   Xcoord, 6
                 xorlw  b'01111111'
                andlw   b'00111111'
                movwf   countno
                bsf     countno, 7
                call    getwelcomebyte
                movwf   Y1_PTRHIGH
                rrf     Y1_PTRHIGH, F
                rrf     Y1_PTRHIGH, F
                movlw   b'00111111'
                andwf   Y1_PTRHIGH, F
                clrf    BITS1_PTR
                bsf     BITS1_PTR, 3
                call    DRAWDOT
                incf    Xcoord, F
                decfsz  Ycoord, F
                 goto   nextsineish
                                 
                call    wait_key
                
                bsf     BITS1_PTR, 3
                call    CLEAR_GRAPHIC
                clrf    Xcoord
                clrf    Ycoord
                bsf     movement, Ymovebit
                bsf     movement, Xmovebit
                
bouncebox
                movlw   b'10010000'
                movwf   BITS1_PTR
                
                movf    Xcoord, W
                movwf   X1_PTRLOW
                btfsc   STATUS, Z
                 bsf    movement, Xmovebit
                
                movf    Ycoord, W
                movwf   Y1_PTRHIGH
                btfsc   STATUS, Z
                 bsf    movement, Ymovebit
                                
                movlw   0x16
                addwf   Xcoord, W
                movwf   X2_PTRLOW
                sublw   0xEF
                btfsc   STATUS, Z
                 bcf    movement, Xmovebit
                
                movlw   0x16
                addwf   Ycoord, W
                movwf   Y2_PTRHIGH
                sublw   0x3F
                btfsc   STATUS, Z
                 bcf    movement, Ymovebit
                                   
                call    DRAWRECT
                
                decf    Xcoord, W
                btfsc   movement, Xmovebit
                 incf   Xcoord, W
                movwf   Xcoord
                              
                decf    Ycoord, W
                btfsc   movement, Ymovebit
                 incf   Ycoord, W
                movwf   Ycoord
                
                bsf     PORTA, 4
                nop
                nop
                nop
                btfsc   PORTA, 4
                 goto    bouncebox
                call    wait_key
                

;now text stuff

                        call    INITTEXTDIS
                                
;clear screen
                        movlw   (high(TEXTSTART))
                        call    HOME_POINTER
                
                        clrf    DATABUFA
                        
                        clrf    temptwo
textloop                movlw   DATA_WR_INC
                        movwf   COMMANDBUF
                        call    SEND_1DATA_CMD   
                        incf    DATABUFA, F
                        decfsz  temptwo, F
                        goto    textloop
                        
                        movlw   (high(TEXTSTART))
                        call    HOME_POINTER
                
                        call    wait_key
                        
                        ;return
                
                
                
                ;bsf     BITS1_PTR, 3
                ;call    CLEAR_GRAPHIC
                ;call    wait_key
                
                ;bcf     BITS1_PTR, 3
                ;call    CLEAR_GRAPHIC
                ;call    wait_key





                goto    startofshapes
                
                
 include "dmshapes.asm"
 include "delay.asm"


choose_key      call    wait_key
                movlw   0x16
                movwf   tempthree
choose_key2     Wait    20 Millisec, 0
                bsf     PORTA, 4
                nop
                nop
                nop
                
                btfss   PORTA, 4
                 goto    keydouble
                decfsz  tempthree, F
                goto    choose_key2
                retlw   1
keydouble       Wait    20 Millisec, 0
choose_key3     btfss   PORTA, 4
                goto    choose_key3
                Wait    20 Millisec, 0                
                bcf     PORTA, 4
                retlw   0


wait_key
                bsf     PORTA, 4
                nop
                nop
                nop
                btfsc   PORTA, 4
                goto    wait_key
                Wait    20 Millisec, 0
wait_key2       btfss   PORTA, 4
                goto    wait_key2
                Wait    20 Millisec, 0                
                bcf     PORTA, 4
                return
                
                
                
displayhalf     

                clrf    DATABUFA
                btfsc   DATABUFB, 7
                 bsf    DATABUFA, 7
                btfsc   DATABUFB, 6
                 bsf    DATABUFA, 5
                btfsc   DATABUFB, 5
                 bsf    DATABUFA, 3
                btfsc   DATABUFB, 4
                 bsf    DATABUFA, 1
                bcf     STATUS, C
                rrf     DATABUFA, W
                iorwf   DATABUFA, F
                movlw   DATA_WR_INC
                movwf   COMMANDBUF
                goto    SEND_1DATA_CMD   
                ;return
                               
 
getwelcomebyte
                org     0x2FE
                movwf   tempone
                movlw   0x03
                movwf   PCLATH
                movf    countno, W
                ;retlw   0xAA
                addwf   PCL, F
                dt      0x82, 0xFE, 0x80, 0x80, 0x7C   ;, 0x1F, 0x25, 0x2C  ;0 - 7
                dt      0x82, 0xFE, 0x80, 0x80, 0x7C   ;, 0x1F, 0x25, 0x2C  ;0 - 7
                
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0x50, 0x56, 0x5C  ;8 - 15
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0x50, 0x56, 0x5C  ;8 - 15
                
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0x7E, 0x83, 0x88  ;16 - 23
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0x7E, 0x83, 0x88  ;16 - 23
                
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0x7E, 0x83, 0x88  ;16 - 23
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0x7E, 0x83, 0x88  ;16 - 23
                
                dt      0xFE, 0xF8, 0x80, 0x80, 0x82   ;, 0xA7, 0xAB, 0xB0  ;24 - 31
                dt      0xFE, 0xF8, 0x80, 0x80, 0x82   ;, 0xA7, 0xAB, 0xB0  ;24 - 31
                
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0xC9, 0xCD, 0xD0  ;32 - 39
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0xC9, 0xCD, 0xD0  ;32 - 39
                
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0xE4, 0xE7, 0xE9  ;40 - 47
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0xE4, 0xE7, 0xE9  ;40 - 47
                
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0xF6, 0xF7, 0xF9  ;48 - 55
                dt      0x82, 0x80, 0x80, 0x80, 0x82   ;, 0xF6, 0xF7, 0xF9  ;48 - 55
                
                dt      0x82, 0xFE, 0xFE, 0xFE, 0x7C   ;, 0xFE, 0xFF, 0xFF  ;56 - 63
                dt      0x82, 0xFE, 0xFE, 0xFE, 0x7C   ;, 0xFE, 0xFF, 0xFF  ;56 - 63
                
                
                dt      0xEE, 0xEE, 0xEE;, 0x9D;, 0xA2, 0xA7;, 0xAB, 0xB0  ;24 - 31
                dt      0xAA, 0xAA, 0xAA;, 0xC1;, 0xC5, 0xC9, 0xCD, 0xD0  ;32 - 39
                dt      0xAA, 0xAA, 0xAA;, 0xDE;, 0xE1, 0xE4, 0xE7, 0xE9  ;40 - 47
                dt      0xEE, 0xEE, 0xEE;, 0xF2;, 0xF4, 0xF6, 0xF7, 0xF9  ;48 - 55
                dt      0x10, 0x10, 0x10;, 0xFD;, 0xFE, 0xFE, 0xFF, 0xFF  ;56 - 63
                dt      0x10, 0x10, 0x10;, 0x9D;, 0xA2, 0xA7;, 0xAB, 0xB0  ;24 - 31
                dt      0x10, 0x10, 0x10;, 0xC1;, 0xC5, 0xC9, 0xCD, 0xD0  ;32 - 39
                dt      0x82, 0x82, 0x82;, 0xDE;, 0xE1, 0xE4, 0xE7, 0xE9  ;40 - 47
                dt      0x7C, 0x7C, 0x7C;, 0xF2;, 0xF4, 0xF6, 0xF7, 0xF9  ;48 - 55
                
                ;JUNK BYTES TO GET TO 128
                dt      0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFE, 0xFF, 0xFF  ;56 - 63
                dt      0xFA, 0xFB, 0xFC;, 0xFD, 0xFE, 0xFE, 0xFF, 0xFF  ;56 - 63                
                
                ;FIRST QUADRENT OF SINE
                dt      0x00, 0x06, 0x0D, 0x13, 0x19, 0x1F, 0x25, 0x2C  ;128
                dt      0x32, 0x38, 0x3E, 0x44, 0x4A, 0x50, 0x56, 0x5C  ;8 - 15
                dt      0x62, 0x67, 0x6D, 0x73, 0x78, 0x7E, 0x83, 0x88  ;16 - 23
                dt      0x8E, 0x93, 0x98, 0x9D, 0xA2, 0xA7, 0xAB, 0xB0  ;24 - 31
                dt      0xB4, 0xB9, 0xBD, 0xC1, 0xC5, 0xC9, 0xCD, 0xD0  ;32 - 39
                dt      0xD4, 0xD7, 0xDB, 0xDE, 0xE1, 0xE4, 0xE7, 0xE9  ;40 - 47
                dt      0xEC, 0xEE, 0xF0, 0xF2, 0xF4, 0xF6, 0xF7, 0xF9  ;48 - 55
                dt      0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFE, 0xFF, 0xFF  ;56 - 63
                dt      0x00, 0x06, 0x0D, 0x13, 0x19, 0x1F, 0x25, 0x2C  ;0 - 7
                dt      0x32, 0x38, 0x3E, 0x44, 0x4A, 0x50, 0x56, 0x5C  ;8 - 15
                dt      0x62, 0x67, 0x6D, 0x73, 0x78, 0x7E, 0x83, 0x88  ;16 - 23
                dt      0x8E, 0x93, 0x98, 0x9D, 0xA2, 0xA7, 0xAB, 0xB0  ;24 - 31
                dt      0xB4, 0xB9, 0xBD, 0xC1, 0xC5, 0xC9, 0xCD, 0xD0  ;32 - 39
                dt      0xD4, 0xD7, 0xDB, 0xDE, 0xE1, 0xE4, 0xE7, 0xE9  ;40 - 47
                dt      0xEC, 0xEE, 0xF0, 0xF2, 0xF4, 0xF6, 0xF7, 0xF9  ;48 - 55
                dt      0x00, 0xFF, 0x00, 0xFF

        end
