        nolist
;******************************************************************************
;
;  This is the custom Header File for T6963C based Dot Matrix LCDs
;       PROGRAM:        T6963C.H
;       Revision:       23-03-97
;
;
;************************
; LCD Module commands:- *
;************************
;
; Register set commands:-
CURSOR_PTR_SET          EQU     0x021   ;Cursor Pointer Set: Data = X,Y
OFFSET_REG_SET          EQU     0x022   ;Offset Register Set: Data = data,0
ADDR_PTR_SET            EQU     0x024   ;Address Pointer Set: Data = low, high addr

; Control Word Set commands:-
TEXT_HOME_SET           EQU     0x040   ;Text Home Address Set: Data = low, high addr
TEXT_AREA_SET           EQU     0x041   ;Text Area Set: Data = columns, 0
GRAPH_HOME_SET          EQU     0x042   ;Graphics Home address Set: Data = low, high addr
GRAPH_AREA_SET          EQU     0x043   ;Graphics Area Set: Data = columns, 0

; Mode Set commands (OR with CG rom commands):-
OR_MODE                 EQU     0x080   ;OR mode
XOR_MODE                EQU     0x081   ;XOR mode
AND_MODE                EQU     0x083   ;AND mode
TEXT_ATTR_MODE          EQU     0x084   ;Text Attribute mode
INT_CG_MODE             EQU     0x080   ;Internal CG ROM mode
EXT_CG_MODE             EQU     0x088   ;External CG ROM mode

; Display Mode commands (OR together required bits):-
DISPLAY_OFF             EQU     0x090   ;display off
BLINK_ON                EQU     0x091
CURSOR_ON               EQU     0x092
TEXT_ON                 EQU     0x094
GRAPHIC_ON              EQU     0x098

;Cursor Pattern Select
CURSOR_1LINE            EQU     0x0A0
CURSOR_2LINE            EQU     0x0A1
CURSOR_3LINE            EQU     0x0A2
CURSOR_4LINE            EQU     0x0A3
CURSOR_5LINE            EQU     0x0A4
CURSOR_6LINE            EQU     0x0A5
CURSOR_7LINE            EQU     0x0A6
CURSOR_8LINE            EQU     0x0A7

;Data Auto Read/Write
DATA_AUTO_WR            EQU     0x0B0
DATA_AUTO_RD            EQU     0x0B1
AUTO_DATA_RESET         EQU     0x0B2

;Data Read/Write
DATA_WR_INC             EQU     0x0C0   ;Data write and increment addr: Data = data
DATA_RD_INC             EQU     0x0C1   ;Data read and increment addr
DATA_WR_DEC             EQU     0x0C2   ;Data write and decrement addr: Data = data
DATA_RD_DEC             EQU     0x0C3   ;Data read and decrement addr
DATA_WR                 EQU     0x0C4   ;Data write - no addr change: Data = data
DATA_RD                 EQU     0x0C5   ;Data read - no addr change

;Screen Peek
SCREEN_PEEK             EQU     0x0E0

;Screen Copy
SCREEN_COPY             EQU     0x0E8

;Bit Set/Reset (OR with bit number 0-7)

BIT_RESET               EQU     0x0F0
BIT_SET                 EQU     0x0F8

;************************
; STATUS bits           *
;************************

STA0                    EQU     0       ;command excution status
STA1                    EQU     1       ;data read/write status
STA2                    EQU     2       ;auto data read status
STA3                    EQU     3       ;auto data write status
STA5                    EQU     5       ;controller status
STA6                    EQU     6       ;peek/copy error flag
STA7                    EQU     7       ;blink? or blank? status

        list
