;
; This program interfaces to a 240 x 64 dot matrix LCD module,
;  using the Tosh T6963C control chip

;****************************************************************************
;* This file and the resulting compiled code copyright1993-96 Steve Lawther *
;*      Use of any of this code requires Steve Lawther to have a credit     *
;*        within the source code. Commercial use of any of this code        *
;*           requires the permission of the author, Steve Lawther           *
;*   For more details read 'README.TXT' or email 100255.157@compuserve.com  *
;****************************************************************************
 include <t6963c.h>
; include "wait.mac"
;
LCD_DATA         EQU     PORTB
LCD_DATA_TRIS    EQU     TRISB
LCD_CTRL         EQU     PORTA
; LCD Display Commands and Control Signal names.
;
#define LCD_CE   LCD_CTRL,3   ; LCD Enable control line
#define LCD_RD   LCD_CTRL,1   ; LCD Read control line
#define LCD_WR   LCD_CTRL,2   ; LCD Write control line
#define LCD_C_D  LCD_CTRL,0   ; LCD Control/data Select line
#define LED      LCD_CTRL,4
;
;
 page

;*******************************************************************
;* The LCD Module Subroutines                                      *
;*******************************************************************
;
;*******************************************************************
;*AutoSend - Sends a byte to the LCD                               *
;* data1 in DATABUFA                                               * 
;* assumes that the autowrite command has been sent                *
;*******************************************************************
;
;AUTOSEND
;                CALL    AUTOSTATUS_CHECK      ; Wait for LCD to be ready
;                ;sets CE, C/D & WR, clears RD, Data lines O/Ps
;                movf    DATABUFA, W
;                movwf   LCD_DATA
;                bcf     LCD_C_D
;                bsf     LCD_RD
;                bcf     LCD_WR
;                bcf     LCD_CE
;                nop                    
;                bsf     LCD_CE         
;                return


;*******************************************************************
;* GRAPH_PTR_HOME - addr pointer to start of graphics              *
;* HOME_POINTER - addr pointer to high addr in W, low = 0          *
;* MOVE_POINTER - sets addr pointer to high addr in W,             *
;* low addr in DATABUFB                                            *
;*******************************************************************

GRAPH_PTR_HOME
                        movlw   (high(GRAPHICSTART))
HOME_POINTER                        
                        clrf    DATABUFB
MOVE_POINTER                        
                        movwf   DATABUFA
                        movlw   ADDR_PTR_SET
                        movwf   COMMANDBUF

;*******************************************************************
;* SEND_2DATA_CMD - Sends 2 byte of data and command to LCD        *
;* command in COMMANDBUF, data1 in DATABUFA, data2 in DATABUFB     *
;*******************************************************************

SEND_2DATA_CMD
                CALL    BUSY_CHECK      ; Wait for LCD to be ready
                ;sets CE, C/D & WR, clears RD, Data lines O/Ps
                movf    DATABUFB, W
                movwf   LCD_DATA
                bcf     LCD_C_D
                bsf     LCD_RD
                bcf     LCD_CE
                bcf     LCD_WR
                nop                    ;busy check call long enough
                bsf     LCD_WR
                bsf     LCD_CE         ;busy_check will set CE high again

;*******************************************************************
;* SEND_1DATA_CMD - Sends 1 byte of data and command to LCD        *
;* command in COMMANDBUF, data in DATABUFA                         *
;*******************************************************************

SEND_1DATA_CMD
                CALL    BUSY_CHECK      ; Wait for LCD to be ready
                ;sets CE, C/D & WR, clears RD, Data lines O/Ps
                movf    DATABUFA, W
                movwf   LCD_DATA
                bcf     LCD_C_D
                bsf     LCD_RD
                bcf     LCD_CE
                bcf     LCD_WR
                nop                    ;busy check call long enough
                bsf     LCD_WR
                bsf     LCD_CE         ;busy_check will set CE high again

;*******************************************************************
;* SEND_CMD - Sends command to LCD                                 *
;* command in COMMANDBUF                                           *
;*******************************************************************

SEND_CMD
                CALL    BUSY_CHECK      ; Wait for LCD to be ready
                ;sets CE, C/D & WR, clears RD, Data lines O/Ps
                movf    COMMANDBUF, W
                movwf   LCD_DATA
                bsf     LCD_RD
                bcf     LCD_CE
                bcf     LCD_WR
                nop                    ;busy check call long enough
                bsf     LCD_WR
                bsf     LCD_CE
                return            
            
  
;*******************************************************************
;* This routine checks the busy flags, returns when not busy        *
;*                                                                 *
;* this routine assumes data lines set to O/P                      *
;*******************************************************************
;
STATUS_READ
BUSY_CHECK
                bcf     LED
                bsf     LCD_CE
                BSF     STATUS, RP0     ; Select Register page 1
                clrf    LCD_DATA_TRIS   ; sets it to O/P
                comf    LCD_DATA_TRIS, F ; sets it to I/P
                BCF     STATUS, RP0     ; Select Register page 0
                bsf     LCD_C_D         ; Set LCD to status read
                BSF     LCD_WR
                BCF     LCD_CE          ; Enable
                bcf     LCD_RD
                ;nop                    ;incase the clk is >10MHz
                btfsc   LCD_DATA, STA0  ;if both are high, ready
                btfss   LCD_DATA, STA1
                goto    BUSY_CHECK
                BSF     LCD_RD
                BSF     LCD_CE        
                BSF     STATUS, RP0     ; Select Register page 1
                clrf    LCD_DATA_TRIS   ; back to O/Ps
                BCF     STATUS, RP0     ; Select Register page 0
                bsf     LED
                RETURN

;*******************************************************************
;* This routine checks the auto busy flags, returns when not busy  *
;*                                                                 *
;* this routine assumes data lines set to O/P                      *
;*******************************************************************
;
;AUTOSTATUS_CHECK
;
;                bsf     LCD_CE
;                BSF     STATUS, RP0     ; Select Register page 1
;                clrf    LCD_DATA_TRIS   ; sets it to O/P
;                comf    LCD_DATA_TRIS, F ; sets it to I/P
;                BCF     STATUS, RP0     ; Select Register page 0
;                bsf     LCD_C_D         ; Set LCD to status read
;                BCF     LCD_RD
;                BSF     LCD_WR
;                BCF     LCD_CE          ; Enable
;                ;nop                    ;incase the clk is >10MHz
;                btfsc   LCD_DATA, STA2  ;if both are high, ready
;                btfss   LCD_DATA, STA3
;                goto    AUTOSTATUS_CHECK
;                BSF     LCD_CE        
;                BSF     STATUS, RP0     ; Select Register page 1
;                clrf    LCD_DATA_TRIS   ; back to O/Ps
;                BCF     STATUS, RP0     ; Select Register page 0
;                RETURN


