; These routines provide the primitive shapes for the dot matrix LCD,

;****************************************************************************
;* This file and the resulting compiled code copyright1993-96 Steve Lawther *
;*      Use of any of this code requires Steve Lawther to have a credit     *
;*        within the source code. Commercial use of any of this code        *
;*           requires the permission of the author, Steve Lawther           *
;*   For more details read 'README.TXT' or email 100255.157@compuserve.com  *
;****************************************************************************
 include <t6963c.asm>

GRAPHICSTART    equ     0x0200
TEXTSTART       equ     0x0000
CGRAMSTART      equ     0x1000
                ;*************************************
                ;*                                   *
                ;*    INITIALIZE Graphics DISPLAY    *
                ;*                                   *
                ;*************************************
INIT_GDISPLAY
                movlw   OR_MODE
                movwf   COMMANDBUF
                call    SEND_CMD
                
                ;movlw   (CGRAMSTART >> 11)     ;set character ram to 4k mark
                ;movwf   DATABUFA
                ;clrf    DATABUFB
                ;movlw   OFFSET_REG_SET
                ;movwf   COMMANDBUF
                ;call    SEND_2DATA_CMD
                                
                MOVLW   GRAPHIC_ON ; Display On
                movwf   COMMANDBUF
                CALL    SEND_CMD        

                ;movlw   CURSOR_5LINE
                ;movwf   COMMANDBUF
                ;call    SEND_CMD
                
                movlw   (high(GRAPHICSTART))
                movwf   DATABUFA
                clrf    DATABUFB
                movlw   GRAPH_HOME_SET
                movwf   COMMANDBUF
                call    SEND_2DATA_CMD
                
                movlw   0x20            ;32 columns, not 30 to make calcs easier
                movwf   DATABUFB
                clrf    DATABUFA
                movlw   GRAPH_AREA_SET
                movwf   COMMANDBUF
                call    SEND_2DATA_CMD
                
                ;clrf    DATABUFA
                
                goto    GRAPH_PTR_HOME
                

                ;*********************************
                ;*                               *
                ;*    INITIALIZE Test DISPLAY    *
                ;*                               *
                ;*********************************

INITTEXTDIS
                movlw   OR_MODE
                movwf   COMMANDBUF
                call    SEND_CMD
                
                ;movlw   (CGRAMSTART >> 11)     ;set character ram to 4k mark
                ;movwf   DATABUFA
                ;clrf    DATABUFB
                ;movlw   OFFSET_REG_SET
                ;movwf   COMMANDBUF
                ;call    SEND_2DATA_CMD
                                
                MOVLW   TEXT_ON                 ; Display On
                movwf   COMMANDBUF
                CALL    SEND_CMD        

                movlw   CURSOR_5LINE
                movwf   COMMANDBUF
                call    SEND_CMD
                
                movlw   (high(TEXTSTART))
                movwf   DATABUFA
                clrf    DATABUFB
                movlw   TEXT_HOME_SET
                movwf   COMMANDBUF
                call    SEND_2DATA_CMD
                
                movlw   0x20            ;32 columns, not 30 to make calcs easier
                movwf   DATABUFB
                clrf    DATABUFA
                movlw   TEXT_AREA_SET
                movwf   COMMANDBUF
                call    SEND_2DATA_CMD
                
                clrf    DATABUFB
                clrf    DATABUFA
                movlw   CURSOR_PTR_SET
                movwf   COMMANDBUF
                call    SEND_2DATA_CMD
                
                
                movlw   (high(TEXTSTART))
                goto    HOME_POINTER
                


;
;
;*******************************************************************
;* The LCD Module Subroutines                                      *
;*******************************************************************

;Decode X-Y

;X = 0-239 (dots across the screen)
;Y = 0-63  (dots down the screen)

;convert to pointer address and bit within byte

; X in Xx_PTRHIGH
; Y in Yx_PTRLOW
; colour/fill details in top of BITSx_PTR (low 3 bits must be clear)
; returns
; PTRHIGH in X_or_PTRHIGH
; PTRLOW in Y_or_PTRLOW
; bit in PTRBIT
; 

; equations are:-

; bit = X%8
; PTR = X/8 + (Y*32) 32 instead of 30 for ease and speed

DECODEXY1       movlw   b'11111000'
                andwf   BITS1_PTR, F
                movlw   b'00000111'
                andwf   X1_PTRLOW, W
                sublw   b'00000111'
                iorwf   BITS1_PTR, F

                rrf     Y1_PTRHIGH, F
                rrf     X1_PTRLOW, F
                rrf     Y1_PTRHIGH, F
                rrf     X1_PTRLOW, F
                rrf     Y1_PTRHIGH, F
                rrf     X1_PTRLOW, F
;PTRLOW now correct

                movlw   b'00000111'
                andwf   Y1_PTRHIGH, F
                movlw   ( high(GRAPHICSTART) )
                addwf   Y1_PTRHIGH, F      
                return

; this routine puts a dot, colour BIT1_PTR bit 3 (0-2 are bit no),
; at X1_PTRHIGH, Y1_PTRLOW

DRAWDOT         call    DECODEXY1

GIVE_A_DOT      movf    X1_PTRLOW, W
                movwf   DATABUFB
                movf    Y1_PTRHIGH, W
                ;movwf   DATABUFA
                ;movlw   ADDR_PTR_SET
                ;movwf   COMMANDBUF
                ;call    SEND_2DATA_CMD
                call    MOVE_POINTER

ANOTHERDOT      movf    BITS1_PTR, W
                andlw   b'00001111'
                iorlw   BIT_RESET
                movwf   COMMANDBUF
                call    SEND_CMD
                return


; this routine draws a horizontal line, colour BIT1_PTR bit 3 (0-2 are bit no),
; from X1_PTRHIGH, Y1_PTRLOW to X2_PTRHIGH
;
DRAWHORIZ       movf    X1_PTRLOW, W
                subwf   X2_PTRLOW, W
                btfss   STATUS, C
                 goto    REVERSEDIRN
                movwf   tempone
                incf    tempone, F         ;tempone stores actual no of dots 
                ;call    DECODEXY1
                call    DRAWDOT
                ;call    GIVE_A_DOT      ;this will set position, and print dot
                                        ;which repeats to save code
                
                movf    BITS1_PTR, W    ;if its a start of byte goto byte writing
                andlw   b'00000111'
                xorlw   b'00000111'
                btfsc   STATUS, Z
                 goto   midLtoR
                               
                incf    DATABUFB, F
startLtoR       call    ANOTHERDOT
                decf    tempone, F
                btfsc   STATUS, Z
                 return
                movf    BITS1_PTR, W
                andlw   b'00000111'
                btfsc   STATUS, Z
                 goto   midLtoR
                decf    BITS1_PTR, F
                goto    startLtoR
                
midLtoR         movlw   ADDR_PTR_SET
                movwf   COMMANDBUF
                call    SEND_2DATA_CMD

midLtoRnoA
                movf    tempone, W              ;if less than 8 dots left,
                andlw   b'11111000'             ;no mid section
                btfsc   STATUS, Z
                 goto   endLtoR
                
                clrf    DATABUFA
                btfsc   BITS1_PTR, 3
                 decf    DATABUFA, F        ;set to 255 if colour black
                movlw   DATA_WR_INC
                movwf   COMMANDBUF
                call    SEND_1DATA_CMD
                
                movlw   0x08
                subwf   tempone, F
                btfss   STATUS, Z
                 goto    midLtoRnoA
                return 
                
endLtoR         movlw   b'00000111'
                iorwf   BITS1_PTR, F
endLtoRloop     call    ANOTHERDOT
                decf    BITS1_PTR, F
                decfsz  tempone, F
                 goto   endLtoRloop
                return
                 
                
;this just flips the start and end points to save coding R to L
REVERSEDIRN     movf    X2_PTRLOW, W
                movwf   tempone
                movf    X1_PTRLOW, W
                movwf   X2_PTRLOW
                movf    tempone, W
                movwf   X1_PTRLOW
                goto    DRAWHORIZ
                
                                
; this routine draws a vertical line, colour BIT1_PTR bit 3 (0-2 are bit no),
; from X1_PTRLOW, Y1_PTRHIGH to Y2_PTRHIGH

DRAWVERT        movf    Y1_PTRHIGH, W
                subwf   Y2_PTRHIGH, W
                movwf   tempone
                call    DECODEXY1
NEXT_VLINEDOT   call    GIVE_A_DOT
;check if at the final point yet.
                movf    tempone, F
                btfsc   STATUS, Z
                 return
                btfsc   tempone, 7
                 goto   UPLINE
                decf    tempone, F
                movlw   0x20
                addwf   X1_PTRLOW, F
                btfsc   STATUS, C
                 incf   Y1_PTRHIGH, F
                goto    NEXT_VLINEDOT

UPLINE          incf    tempone, F
                movlw   0x20
                subwf   X1_PTRLOW, F
                btfss   STATUS, C
                 decf   Y1_PTRHIGH, F
                goto    NEXT_VLINEDOT

; This routine draws a rectangle, from X1_PTRLOW, Y1_PTRHIGH to X2_PTRLOW, Y2_PTRHIGH
;                                 BITS1_PTR bit 3 colour (outer line)
;                                        if bit 4 fill = 1,
;                               filled with bit 7 colour (fill colour)
;                                           

FILL_ON         equ     4

DRAWRECT        movf    X1_PTRLOW, W
                movwf   temptwo
                movf    Y1_PTRHIGH, W
                movwf   tempthree
                movwf   shapecount
                
                btfss   BITS1_PTR, FILL_ON
                 goto   outer_line
                swapf   BITS1_PTR, F
                 ;movlw   b'10001000'
                 ;andwf   BITS1_PTR, F
                
next_rfill      call    DRAWHORIZ
                movf    Y2_PTRHIGH, W
                subwf   shapecount, W
                btfsc   STATUS, Z
                 goto   end_of_fill
                incf    shapecount, F
                movf    shapecount, W
                movwf   Y1_PTRHIGH
                movf    temptwo, W
                movwf   X1_PTRLOW    
                goto    next_rfill
                
end_of_fill     movf    BITS1_PTR, W
                andlw   b'10000000'
                swapf   BITS1_PTR, F            ;if the line colour is the same
                xorwf   BITS1_PTR, F            ;as the fill colour then finished
                btfss   BITS1_PTR, 7
                 return
                movf    tempthree, W
                movwf   Y1_PTRHIGH
                movf    temptwo, W
                movwf   X1_PTRLOW    
                                
outer_line      call    DRAWHORIZ
                movf    temptwo, W
                movwf   X1_PTRLOW
                movf    tempthree, W
                movwf   Y1_PTRHIGH
                call    DRAWVERT
                movf    temptwo, W
                movwf   X1_PTRLOW
                movf    Y2_PTRHIGH, W
                movwf   Y1_PTRHIGH
                call    DRAWHORIZ
                movf    X2_PTRLOW, W
                movwf   X1_PTRLOW
                movf    tempthree, W
                movwf   Y1_PTRHIGH
                call    DRAWVERT
                return
                
; CLEAR_GRAPHIC - This routine clears the graphics screen to
; all black (BITS1_PTR bit 3 = 1) or all white (BITS1_PTR bit 3 = 0)
;
CLEAR_GRAPHIC                
                        call    GRAPH_PTR_HOME
                        
                        clrf    DATABUFA
                        btfsc   BITS1_PTR, 3
                        comf    DATABUFA, F 
                        movlw   0x08
                        movwf   tempone
lcdloop1                clrf    temptwo
lcdloop2                movlw   DATA_WR_INC
                        movwf   COMMANDBUF
                        call    SEND_1DATA_CMD   
                        decfsz  temptwo, F
                        goto    lcdloop2
                        decfsz  tempone, F
                        goto    lcdloop1
                        
                        call    GRAPH_PTR_HOME
                        return
                        
