;********************************************************************
;*                                                                  *
;*                     Bourns(tm) ACE decoder                       *
;*                          Version B(hex)                          *
;*                 Steve Lawther copyright 1996                     *
;********************************************************************
;*This file and the resulting compiled code                         *
;*                                     copyright 1996 Steve Lawther *
;* Use of any of this code requires Steve Lawther to have a credit  *
;*    within the source code. Commercial use of any of this code    *
;*        requires permission of the author, Steve Lawther          *
;*          For more details email steve.lawther@gecm.com           *
;*                                                                  *
;*  Bourns and ACE are trademarks of Bourns, inc.                   *
;********************************************************************
;
;This code is convert the O/P of a Bourn's ACE positional encoder
;to a position number 0 to 127.
;It is written to save the hearts of those who look at the data 
;sheet and realise that Bourns recommend a 256 byte look-up table!!
; ie ACETAB (upto 1/2 of the code memory of a PIC!!)
; The flip-side of this is the time to convert is much longer!
; - you win some,...
;The routine is approx 91 bytes as opposed to 256 in a look-up
;table, but can take from 22 upto 59 cycles! (valid ACE codes);
;The invalid code 0x00 take 60 cycles.

;Enter with bourns ACE O/P in Acein
;Returns with position number (0 to 127) in Count, 255 for invalid codes
;

;This version rotates ACEIN to get a msb 0 and next msb 1 then compares 
;it with 64 possibles

Bourns128decd   
                clrf    Count
                call    AceEnter   
                btfsc   Count, 7        ;if count is FF, it's an invalid code
                 return
                swapf   Count, F
                addwf   Count, F
                bcf     Count, 7
                return   

AceNot01        ;done 4 rotates? (4 + swaps)
                incf    Count, F
                btfsc   Count, 2
                 goto   invld
                
                rlf     Acein, W
                rlf     Acein, F        ;rotate acein
AceEnter        btfss   Acein, 7        ;is acein bit 7 clear 
                btfss   Acein, 6        ; & bit 6 set
                 goto   Acenext
                movf    Acein, W
                goto    Readit
                
Acenext         btfss   Acein, 3        ;is acein bit 3 clear
                btfss   Acein, 2        ; & bit 2 set
                 goto   AceNot01
                
                bsf     Count, 2
                swapf   Acein, W 
Readit          andlw   b'00111111'
                addwf   PCL, F                

                dt      0x58    ;b'01000000'
                goto    invld   ;b'01000001'
                dt      0x59    ;b'01000010'
                goto    invld   ;b'01000011'
                
                goto    invld   ;b'01000100'
                goto    invld   ;b'01000101'
                goto    invld   ;b'01000110'
                dt      0x33    ;b'01000111'
                          
                dt      0x09    ;b'01001000'
                dt      0x0A    ;b'01001001'
                dt      0x5A    ;b'01001010'
                goto    invld   ;b'01001011'
                
                dt      0x16    ;b'01001100'
                dt      0x0B    ;b'01001101'
                goto    invld   ;b'01001110'
                dt      0x0C    ;b'01001111'

                goto    invld   ;b'01010000'
                goto    invld   ;b'01010001'
                dt      0x2A    ;b'01010010'
                dt      0x2B    ;b'01010011'
                                                       
                goto    invld   ;b'01010100'
                goto    invld   ;b'01010101'
                goto    invld   ;b'01010110'
                goto    invld   ;b'01010111'
                
                goto    invld   ;b'01011000'
                goto    invld   ;b'01011001'
                goto    invld   ;b'01011010'
                goto    invld   ;b'01011011'
                
                dt      0x15    ;b'01011100'
                goto    invld   ;b'01011101'
                dt      0x7E    ;b'01011110'
                dt      0x7F    ;b'01011111'

                dt      0x67    ;b'01100000'
                goto    invld   ;b'01100001'
                dt      0x66    ;b'01100010'
                goto    invld   ;b'01100011'
                
                goto    invld   ;b'01100100'
                goto    invld   ;b'01100101'
                goto    invld   ;b'01100110'
                goto    invld   ;b'01100111'
                
                goto    invld   ;b'01101000'
                goto    invld   ;b'01101001'
                dt      0x5B    ;b'01101010'
                goto    invld   ;b'01101011'
                                      
                goto    invld   ;b'01101100'
                goto    invld   ;b'01101101'
                goto    invld   ;b'01101110'
                goto    invld   ;b'01101111'
    
                dt      0x74    ;b'01110000'
                dt      0x75    ;b'01110001'
                goto    invld   ;b'01110010'
                goto    invld   ;b'01110011'
                                       
                dt      0x73    ;b'01110100'
                goto    invld   ;b'01110101'
                goto    invld   ;b'01110110'
                goto    invld   ;b'01110111'
                
                dt      0x5D    ;b'01111000'
                dt      0x5E    ;b'01111001'
                dt      0x5C    ;b'01111010'
                goto    invld   ;b'01111011'
                
                dt      0x72    ;b'01111100'
                dt      0x5F    ;b'01111101'
                dt      0x71    ;b'01111110'
                dt      0x00    ;b'01111111'

invld           movlw   0xFF
                movwf   Count
                retlw   0x00

