;********************************************************************
;*                                                                  *
;*                     Bourns(tm) ACE decoder                       *
;*                          Version 8                               *
;*                 Steve Lawther copyright 1996                     *
;********************************************************************
;*This file and the resulting compiled code                         *
;*                                     copyright 1996 Steve Lawther *
;* Use of any of this code requires Steve Lawther to have a credit  *
;*    within the source code. Commercial use of any of this code    *
;*        requires permission of the author, Steve Lawther          *
;*          For more details email steve.lawther@gecm.com           *
;*                                                                  *
;*  Bourns and ACE are trademarks of Bourns, inc.                   *
;********************************************************************
;
;This code is convert the O/P of a Bourn's ACE positional encoder
;to a position number 0 to 127.
;It is written to save the hearts of those who look at the data 
;sheet and realise that Bourns recommend a 256 byte look-up table!!
; ie ACETAB (upto 1/2 of the code memory of a PIC!!)
; The flip-side of this is the time to convert is much longer!
; - you win some,...
;The routine is approx 76 bytes as opposed to 256 in a look-up
;table, but can take upto 135 cycles! (valid ACE codes);
;The invalid code 0xAA can take 153 cycles.

;enter with bourns ACE O/P in acein

;This version rotates ACEIN to get a msb 1 and lsb 0 then compares 
;it with 16 values

Bourns128decd   
                clrf    Count
                call    AceEnter   
                btfsc   Count, 7
                goto    AceError
                addwf   Count, F
                bcf     Count, 7
                return   
AceError        movwf   Count
                return

NextRotate
AceNot01        movlw   0x10
                addwf   Count, F    ;done 8 rotates?
                btfsc   Count, 7
                retlw   0xFF
                rlf     Acein, W
                rlf     Acein, F    ;rotate acein
AceEnter        btfss   Acein, 0    ;is acein LSB 0 
                btfss   Acein, 7    ; & MSB 1
                goto    AceNot01
                
                movf    Acein, W   
                addlw   (0 - b'11100010')
                btfsc   STATUS, Z
                retlw   0x65
                
                btfsc   STATUS, C       
                goto    ace1hthan
                
                addlw   (b'11100010' - b'11000000')
                btfsc   STATUS, Z
                retlw   0x57
                btfsc   STATUS, C
                goto    acelow2hthan
                
                addlw   (b'11000000' - b'10010010')
                btfsc   STATUS, Z
                retlw   0x48
                btfsc   STATUS, C               ;****
                goto    NextRotate              ;****
                addlw   (b'10010010' - b'10010000')
                btfsc   STATUS, Z
                retlw   0x79
                addlw   (b'10010000' - b'10000000')
                btfsc   STATUS, Z
                retlw   0x7A
                goto    NextRotate
                
acelow2hthan    addlw   (b'11000000' - b'11000100')
                btfsc   STATUS, Z
                retlw   0x56
                addlw   (b'11000100' - b'11010100')
                btfsc   STATUS, Z
                retlw   0x4B
                addlw   (b'11010100' - b'11100000')
                btfsc   STATUS, Z
                retlw   0x64
                goto    NextRotate
                
ace1hthan       addlw   (b'11100010' - b'11110100')
                btfsc   STATUS, Z
                retlw   0x4C
                btfsc   STATUS, C
                goto    ace2highhthan
                
                addlw   (b'11110100' - b'11101000')
                btfsc   STATUS, Z
                retlw   0x63
                addlw   (b'11101000' - b'11110000')
                btfsc   STATUS, Z
                retlw   0x4D
                addlw   (b'11110000' - b'11110010')
                btfsc   STATUS, Z
                retlw   0x4E
                goto    NextRotate
                
ace2highhthan   addlw   (b'11110100' - b'11111000')
                btfsc   STATUS, Z
                retlw   0x62
                addlw   (b'11111000' - b'11111010')
                btfsc   STATUS, Z
                retlw   0x4F
                addlw   (b'11111010' - b'11111100')
                btfsc   STATUS, Z
                retlw   0x61
                addlw   (b'11111100' - b'11111110')
                btfsc   STATUS, Z
                retlw   0x70
                goto    NextRotate
                            
; The end (of this converter)

