;********************************************************************
;*                                                                  *
;*                     Bourns(tm) ACE decoder                       *
;*                          Version 5                               *
;*                 Steve Lawther copyright 1996                     *
;********************************************************************
;*This file and the resulting compiled code                         *
;*                                     copyright 1996 Steve Lawther *
;* Use of any of this code requires Steve Lawther to have a credit  *
;*    within the source code. Commercial use of any of this code    *
;*        requires permission of the author, Steve Lawther          *
;*          For more details email steve.lawther@gecm.com           *
;*                                                                  *
;*  Bourns and ACE are trademarks of Bourns, inc.                   *
;********************************************************************
;
;This code is convert the O/P of a Bourn's ACE positional encoder
;to a position number 0 to 127.
;It is written to save the hearts of these who look at the data 
;sheet and realise that bourns recommend a 256 byte look-up table!!
; ie ACETAB (upto 1/2 of the code memory of a PIC!!)
; The flip-side of this is the time to convert is much longer!
; - you win some,...
;The routine is approx 63 bytes as opposed to 256 in a look-up
;table, but can take upto 300-ish cycles! 

;enter with bourns ACE O/P in acein

;This version rotates ACEIN and compares with 16 values
Bourn128subr
                clrf    Count
                
Bourns128loop   
                movf    Acein, W   
                addlw   - d'63'
                btfsc   STATUS, Z
                retlw   0x01
                
                btfsc   STATUS, C       
                goto    acehthan63
                
                addlw   + d'63' - d'08'
                btfsc   STATUS, Z
                retlw   0x08
                addlw   + d'08' - d'15'
                btfsc   STATUS, Z
                retlw   0x0D
                addlw   + d'15' - d'24'
                btfsc   STATUS, Z
                retlw   0x07
                addlw   + d'24' - d'47'
                btfsc   STATUS, Z
                retlw   0x0E
                addlw   + d'47' - d'56'
                btfsc   STATUS, Z
                retlw   0x04
                addlw   + d'56' - d'58'
                btfsc   STATUS, Z
                retlw   0x03
                addlw   + d'58' - d'62'
                btfsc   STATUS, Z
                retlw   0x02
                goto    next128loop
                
acehthan63      addlw   + d'63' - d'72'
                btfsc   STATUS, Z
                retlw   0x09
                addlw   + d'72' - d'73'
                btfsc   STATUS, Z
                retlw   0x0A
                addlw   + d'73' - d'77'
                btfsc   STATUS, Z
                retlw   0x0B
                addlw   + d'77' - d'79'
                btfsc   STATUS, Z
                retlw   0x0C
                addlw   + d'79' - d'127'
                btfsc   STATUS, Z
                retlw   0x00
                addlw   + d'127' - d'152'
                btfsc   STATUS, Z
                retlw   0x06
                addlw   + d'152' - d'175'
                btfsc   STATUS, Z
                retlw   0x0F
                addlw   + d'175' - d'184'
                btfsc   STATUS, Z
                retlw   0x05
                
next128loop     rlf     Acein, W
                rlf     Acein, F
                                              
                movlw   0x10
                addwf   Count, F
                btfsc   Count, 7
                goto    Bourns128loop

;If it gets to here, it isn't a value bourn's ACE code! 
;so give value 255 - change this if you need to.
                retlw   0xFF

Bourns128conv   
                call    Bourns128subr   
                addwf   Count, F
                return   
                            
; The end (of this converter)

