;********************************************************************
;*                                                                  *
;*                     Bourns(tm) ACE decoder                       *
;*                          Version 1                               *
;*                 Steve Lawther copyright 1996                     *
;********************************************************************
;*This file and the resulting compiled code                         *
;*                                     copyright 1996 Steve Lawther *
;* Use of any of this code requires Steve Lawther to have a credit  *
;*    within the source code. Commercial use of any of this code    *
;*        requires permission of the author, Steve Lawther          *
;*          For more details email steve.lawther@gecm.com           *
;*                                                                  *
;*  Bourns and ACE are trademarks of Bourns, inc.                   *
;********************************************************************
;
;This code is convert the O/P of a Bourn's ACE positional encoder
;to a position number 0 to 127.
;It is written to save the hearts of these who look at the data 
;sheet and realise that bourns recommend a 256 byte look-up table!!
; ie ACETAB (upto 1/2 of the code memory of a PIC!!)
; The flip-side of this is the time to convert is much (much....)
; longer! - you win some,...
;The routine is approx 43 bytes as opposed to 256 in a look-up
;table, but can take upto 2000 ish cycles! 

;enter with bourns ACE O/P in acein

Bourn128conv
                clrf    Count
Bourns128loop   movlw   b'00000111'
                andwf   Count, W
                btfsc   STATUS, Z       ;load a new comp if needed
                call    loadnewcomp
                movwf   comp
                movf    acein, W
                xorwf   comp, W
                btfsc   STATUS, Z       ;Is this the correct value
                goto    end128conv
                rlf     comp, W
                rlf     comp, F
                incf    Count
                btfss   comp, 7 
                goto    Bourns128loop

;If it gets to here, it isn't a value bourn's ACE code! 
;so give value 255 - change this if you need to.
                retlw   255

; move bits 0-2 to bits 4-6 and bits 3-6 to bits 0-3
end128conv      
                swapf   Count, F
                btfsc   Count, 7
                bsf     Count, 0
                bcf     Count, 7
                retlw   0 

;16 byte look up table - a converloted version of 1 bit of
the Bourns(tm) ACETAB

loadnewcomp
                
;bit missing here!                
                rlf     Count, W
                movwf   temp
                swapf   temp, W
                andlw   b'00001111'              
                addwf   PCL, F
                retlw   b'01111111'
                retlw   b'00111111'
                retlw   b'00111110'
                retlw   b'00111010'
                retlw   b'00111000'
                retlw   b'10111000'
                retlw   b'10011000'
                retlw   b'00011000'
                retlw   b'00001000'
                retlw   b'01001000'
                retlw   b'01001001'
                retlw   b'01001101'
                retlw   b'01001111'
                retlw   b'00001111'
                retlw   b'00101111'
                retlw   b'10101111'

; The end (of this converter)

