
;******************************************************************************
;
;  This is the custom Header File for avr_clcd.asm
; Avr version generated from pic version:      LM032l.H
;       			Revision:       9-10-95
;
;******************************************************************************

; LCD Module commands
;
;CLR_DISP - clears all display, and cursor home to addr 0
.equ		CLR_DISP = 0x001                   ; Clear the Display

;RTN_HOME - cursor home and display unshifted, DDRAM unchanged
.equ		RTN_HOME = 0X002

;ENTRY_... - sets entry mode, S = display shift on, INC / DEC cursor move dir
.equ		ENTRY_DEC = 0x004                   ;
.equ		ENTRY_DEC_S = 0x005                   ;
.equ		ENTRY_INC = 0x006                   ;
.equ		ENTRY_INC_S = 0x007                   ;

;DISP_... - Display on / off control, C = cursor ON, B = chr pos blink
.equ		DISP_OFF = 0x008		; Display off
.equ		DISP_ON = 0x00C			; Display on
.equ		DISP_ON_B = 0x00D		; Display on, Cursor Off, Blink character
.equ		DISP_ON_C = 0x00E		; Display on, Cursor on
.equ		DISP_ON_BC = 0x00F		; Display on, Cursor on, Blink character

;SHIFT_... - Cursor & Display shift, S = Display, C = cursor, L = Left, R = Right
.equ		SHIFT_C_L = 0x010
.equ		SHIFT_C_R = 0x014
.equ		SHIFT_S_L = 0x018
.equ		SHIFT_S_R = 0x01C

;FUNC_... - Function set, ( 4 bit, 2 lines, 5 x 7 dots) 
.equ		FUNC_SET = 0x028

;
.equ		CURS_RGT = 0x093
.equ		DD_RAM_ADDR = 0x080                   ; Least Significant 7-bit are for address
.equ		DD_RAM_UL = 0x080                   ; Upper Left coner of the Display
;


;some special characters
.equ		ASCIIDECIMALPOINT = 0xA5
.equ		ASCIIDEGREES = 0xDF
.equ		ASCIIDROPY = ('y' + 0x80)
.equ		ASCIIDROPG = ('g' + 0x80)

