;
; This program interfaces to a 2 line by 20 character display module.
; The program assembles for 4-bit data interface. LCDport is the port 
; which supplies both the data and the control lines ( E, RS, R_W ) to the
; Display
; This program only handles the data though the high nibble.
;****************************************************************************
;* This file and the resulting compiled code copyright1993-99 Steve Lawther *
;*      Use of any of this code requires Steve Lawther to have a credit     *
;*        within the source code. Commercial use of any of this code        *
;*           requires the permission of the author, Steve Lawther           *
;*   For more details read 'README.TXT' or email steve.lawther@husky.co.uk  *
;****************************************************************************

;This code is converted from my PIC version 11/01/97

.include "avr_clcd.h"

.equ	LCDport = PORTC
.equ	LCDdir = DDRC
.equ	LCD_in = PINC

; LCD Display Commands and Control Signal names.
;
.equ	LCD_Epin = 1   ; LCD Enable control line
.equ	LCD_R_Wpin = 2   ; LCD Read/Write control line
.equ	LCD_RSpin = 3   ; LCD Register Select control line

;NOTE:- when communicating with the LCD, PORTC.0 is always set as an output
;		and is set low - This assumes the data nibble is used for
;		other things when PORTC.0 is high
;
;
;
; Initilize the LCD Display Module
;****************************************************************************
;*
;*              DISPLAY RESET
;*
;****************************************************************************

LCD_Reset:
;needs to have full routine to initialize corrupted display
;first setup lcd port - all outputs  

		clr	globaltmp	;set all port low
		out	LCDport, globaltmp

		ser	globaltmp	;set whole port to output
		out	LCDdir, globaltmp

;have to wait 15ms here            

		rcall	Wait15Millisec


                ldi	globaltmp, 0b00110000	; Command for 8-bit interface high nibble
		out	LCDport, globaltmp	; ie 0011xxxx
		sbi	LCDport, LCD_Epin
                nop				;incase the clk is >2MHz
                ;nop				;incase the clk is >4MHz
                cbi	LCDport, LCD_Epin
;have to wait 4.4ms here            
		rcall	Wait4400Microsec
                sbi	LCDport, LCD_Epin	;nibble is already setup
                nop				;incase the clk is >2MHz
                ;nop				;incase the clk is >4MHz
                cbi	LCDport, LCD_Epin
;have to wait 100us here
		rcall	Wait100Microsec
                sbi	LCDport, LCD_Epin	;nibble is already setup
                nop				;incase the clk is >2MHz
                ;nop				;incase the clk is >4MHz
                cbi	LCDport, LCD_Epin
;have to wait 100us here
		rcall	Wait100Microsec
                ldi	globaltmp, 0b00100000	; Command for 4-bit interface high nibble
                out	LCDport, globaltmp			; ie 0010xxxx
                sbi	LCDport, LCD_Epin	;nibble is already setup
                nop				;incase the clk is >2MHz
                ;nop				;incase the clk is >4MHz
                cbi	LCDport, LCD_Epin
;from here interface is 4 bit and busy can be checked
                                        	;          001DL NF**
                ldi	globaltmp, FUNC_SET	;has to be 0010  10XX 
                rcall	LCDSend_Cmd
						;0000 1DCB
                ldi	globaltmp, DISP_OFF	;0000 1000  
                rcall	LCDSend_Cmd

                ;****************************
                ;*                          *
                ;*    INITIALIZE DISPLAY    *
                ;*                          *
                ;****************************
LCD_Init:
                ldi	globaltmp, DISP_ON_C	; Display On, Cursor On
                rcall	LCDSend_Cmd
                
                ldi	globaltmp, CLR_DISP	; Clear the Display
                rcall	LCDSend_Cmd
						;0000 01IS
                ldi	globaltmp, ENTRY_INC	;0000 0110
                rcall	LCDSend_Cmd
            
                ret		;display initiatized

;
;
;*******************************************************************
;* The LCD Module Subroutines                                      *
;*******************************************************************
;
;*******************************************************************
;*LCDSendChar - Sends character to LCD                             *
;*This routine splits the character into the upper and lower       * 
;*nibbles and sends them to the LCD, upper nibble first.           *
;*******************************************************************
;
LCDSend_Char:
		rcall	LCDBusy_Check	;Wait for LCD to be ready
		ldi	globalt2, 0b11110000
		and	globalt2, globaltmp	;Get upper nibble into upper half port
		out	LCDport, globalt2	;Send data to LCD
						;already set LCD to write in busy routine
		sbi	LCDport, LCD_RSpin	;Set LCD to data mode
		rcall	LCDtglclk		;saving space - sod readability thou

		ldi	globalt2, 0b00001111
		and	globalt2, globaltmp	;Get lower nibble into upper half port
		swap	globalt2
		out	LCDport, globalt2	;Send data to LCD
						;already set LCD to read in busy routine
		sbi	LCDport, LCD_RSpin	;Set LCD to data mode
LCDtglclk:
		sbi	LCDport, LCD_Epin	;toggle E for LCD
		nop				;in case the clk is >2MHz
		;nop				;in case the clk is >4MHz
		cbi	LCDport, LCD_Epin
		ret

;*******************************************************************
;* SEND_CMD - Sends command to LCD                                 *
;* This routine splits the command into the upper and lower        * 
;* nibbles and sends them to the LCD, upper nibble first.          *
;*******************************************************************

LCDSend_Cmd:
		rcall	LCDBusy_Check		;Wait for LCD to be ready
		ldi	globalt2, 0b11110000
		and	globalt2, globaltmp	;Get upper nibble into upper half port
		out	LCDport, globalt2	;Send data to LCD
						;already set LCD to write and ctl 
						;in busy routine
		rcall	LCDtglclk		;saving space - sod readability thou

		swap	globaltmp
		ldi	globalt2, 0b11110000
		and	globalt2, globaltmp	;Get lower nibble into upper half port
		out	LCDport, globalt2	;Send data to LCD
						;already set LCD to read in busy routine

		rjmp	LCDtglclk


;*******************************************************************
;* This routine checks the busy flag, returns when not busy        *
;*******************************************************************
;
LCDBusy_Check:

		ldi	globalt2, 0b00001111	; Set high nibble to input 
		out	LCDdir, globalt2
		clr	globalt2		; remove pull-ups on data nibble / clear controls
		out	LCDport, globalt2
						; Set LCD for Command mode RS low
		sbi     LCDport, LCD_R_Wpin	; Setup to read busy flag
		sbi	LCDport, LCD_Epin	; Set E high
		nop
		nop			;in case the clk is >2MHz
		;nop			;in case the clk is >4MHz
		in	globalt2, LCD_in	; Read upper nibble busy flag, DDRam address            
		cbi	LCDport, LCD_Epin	; Set E low

		nop			;in case the clk is >2MHz
		;nop			;in case the clk is >4MHz
		sbi	LCDport, LCD_Epin	; Set E high to get rid of lower nibble
		nop
		nop			;in case the clk is >2MHz
		;nop			;in case the clk is >4MHz
		cbi	LCDport, LCD_Epin	; Set E low

		sbrc	globalt2, 7	; Check busy flag, high = busy
		 rjmp	LCDBusy_Check	;loop if high
		cbi	LCDport, LCD_R_Wpin
		ser	globalt2
		out	LCDdir, globalt2	;set for output
		ret

;.include "delay.asm"

